(function () {
  document.addEventListener("DOMContentLoaded", function () {
    document
      .querySelectorAll("form[data-contact-form]")
      .forEach(function (form) {
        const submitButton = form.querySelector('button[type="submit"]');

        // Criar zona de mensagens
        let messageBox = form.querySelector(".form-message");
        if (!messageBox) {
          messageBox = document.createElement("div");
          messageBox.className = "form-message";
          messageBox.style.marginTop = "10px";
          form.appendChild(messageBox);
        }

        form.addEventListener("submit", function (e) {
          e.preventDefault();

          // Anti double-submit
          if (form.dataset.sending === "true") return;
          form.dataset.sending = "true";

          submitButton.disabled = true;
          messageBox.style.color = "black";
          messageBox.textContent = "A enviar mensagem...";

          const fd = new FormData(form);

          // Honeypot
          if (fd.get("website")) {
            submitButton.disabled = false;
            form.dataset.sending = "false";
            return;
          }

          const payload = {
            name: fd.get("text-name"),
            email: fd.get("email"),
            phone: fd.get("tel"),
            company: fd.get("empresa"),
            subject: fd.get("subject-top")
              ? fd.get("subject-top") + " – " + fd.get("subject")
              : fd.get("subject"),
            message: fd.get("message"),
          };

          fetch("https://test.sng.pt/test-api/contact-form.php", {
            method: "POST",
            headers: {
              "Content-Type": "application/json",
            },
            body: JSON.stringify(payload),
          })
            .then(function (response) {
              return response.json();
            })
            .then(function (data) {
              if (data.success) {
                messageBox.style.color = "green";
                messageBox.textContent = "Mensagem enviada com sucesso.";
                form.reset();
              } else {
                messageBox.style.color = "red";
                messageBox.textContent =
                  data.message || "Erro ao enviar mensagem.";
              }
            })
            .catch(function () {
              messageBox.style.color = "red";
              messageBox.textContent =
                "Erro de ligação. Tente novamente mais tarde.";
            })
            .finally(function () {
              submitButton.disabled = false;
              form.dataset.sending = "false";
            });
        });
      });
  });
})();
